// priority: 100
onEvent('recipes', (event) => {
    //Reprocessor missing recipes
    const reprocessor = (input, output, amountOutputted) => {
        event.custom({
            type: 'mysticalagriculture:reprocessor',
            input: {
                item: input
            },
            result: {
                item: output,
                count: amountOutputted
            }
        }).id(input + '_reprocessor');
    }

    const reprocessorOutputAmount = 32

    //Massively buff reprocessor recipes
    event.forEachRecipe({ type: 'mysticalagriculture:reprocessor' }, recipe => {
        recipe.serializeOutputs = true;
        recipe.outputItems.get(0).setCount(reprocessorOutputAmount);
    });
    
    //Seeds that didn't have a reprocessor output
    reprocessor('mysticalagriculture:basalt_seeds', 'mysticalagriculture:basalt_essence', reprocessorOutputAmount);
    reprocessor('mysticalagriculture:aquamarine_seeds', 'mysticalagriculture:aquamarine_essence', reprocessorOutputAmount);

    //Custom seeds that need a recipe specified
    reprocessor('mysticalagriculture:runewood_seeds', 'mysticalagriculture:runewood_essence', reprocessorOutputAmount);
    reprocessor('mysticalagriculture:archwood_seeds', 'mysticalagriculture:archwood_essence', reprocessorOutputAmount);
    reprocessor('mysticalagriculture:source_gem_seeds', 'mysticalagriculture:source_gem_essence', reprocessorOutputAmount);
    reprocessor('mysticalagriculture:hallowed_gold_seeds', 'mysticalagriculture:hallowed_gold_essence', reprocessorOutputAmount);
    reprocessor('mysticalagriculture:soul_stained_steel_seeds', 'mysticalagriculture:soul_stained_steel_essence', reprocessorOutputAmount);
    reprocessor('mysticalagriculture:iesnium_seeds', 'mysticalagriculture:iesnium_essence', reprocessorOutputAmount);

    //Consider modid as "mysticalagriculture:"
    const modId = 'mysticalagriculture:'
    let modIdLength = modId.length

    const endOfSeed = '_seeds'
    let endOfSeedLength = endOfSeed.length

    //This will allow getting the material from the seed
    //'mysticalagriculture:coal_seeds' => 'mysticalagriculture:' + 'coal' + '_seeds'
    //Which we can then use for the recipe id
    //'mysticalagriculture:seed/infusion/coal'

    //Method for new infusion crafting recipes
    const infusionCrafting = (craftingMaterial, essence, baseSeed, result) => {
        let recipeId = 'mysticalagriculture:seed/infusion/' + result.substring(modIdLength, result.length - endOfSeedLength);
        if (craftingMaterial.startsWith('#')) {
            craftingMaterial = craftingMaterial.substring(1);
            event.custom({
                type: 'mysticalagriculture:infusion',
                input: { item: baseSeed },
                ingredients: [
                    { tag: craftingMaterial },
                    { item: essence },
                    { tag: craftingMaterial },
                    { item: essence },
                    { tag: craftingMaterial },
                    { item: essence },
                    { tag: craftingMaterial },
                    { item: essence }
                ],
                result: {
                    item: result
                }
            }).id(recipeId);
        } else {
            event.custom({
                type: 'mysticalagriculture:infusion',
                input: { item: baseSeed },
                ingredients: [
                    { item: craftingMaterial },
                    { item: essence },
                    { item: craftingMaterial },
                    { item: essence },
                    { item: craftingMaterial },
                    { item: essence },
                    { item: craftingMaterial },
                    { item: essence }
                ],
                result: {
                    item: result
                }
            }).id(recipeId);
        }
    }

    //For very special cases, pass an array instead. Only support items.
    const infusionCrafting4 = (craftingMaterials, essence, baseSeed, result) => {
        let recipeId = 'mysticalagriculture:seed/infusion/' + result.substring(modIdLength, result.length - endOfSeedLength);
        event.custom({
            type: 'mysticalagriculture:infusion',
            input: {
                item: baseSeed
            },
            ingredients: [
                { item: craftingMaterials[0] },
                { item: essence },
                { item: craftingMaterials[1] },
                { item: essence },
                { item: craftingMaterials[2] },
                { item: essence },
                { item: craftingMaterials[3] },
                { item: essence }
            ],
            result: {
                item: result
            }
        }).id(recipeId);
    }

    //What the base seed is
    const baseSeed = 'mysticalagriculture:prosperity_seed_base';

    //Tier 1 recipes
    const ess1 = 'mysticalagriculture:inferium_essence';
    infusionCrafting('#forge:ice', ess1, baseSeed, 'mysticalagriculture:ice_seeds');

    //Tier 2 recipes
    const ess2 = 'mysticalagriculture:prudentium_essence';
    infusionCrafting('#forge:storage_blocks/coal', ess2, baseSeed, 'mysticalagriculture:coal_seeds');
    infusionCrafting('minecraft:budding_amethyst', ess2, baseSeed, 'mysticalagriculture:amethyst_seeds');
    infusionCrafting('#forge:storage_blocks/aluminum', ess2, baseSeed, 'mysticalagriculture:aluminum_seeds');
    infusionCrafting('#mysticalagriculture:material/limestone', ess2, baseSeed, 'mysticalagriculture:limestone_seeds');
    infusionCrafting('minecraft:basalt', ess2, baseSeed, 'mysticalagriculture:basalt_seeds');
    infusionCrafting4(['ars_nouveau:red_archwood_sapling', 'ars_nouveau:purple_archwood_sapling', 'ars_nouveau:blue_archwood_sapling', 'ars_nouveau:green_archwood_sapling'], ess2, baseSeed, 'mysticalagriculture:archwood_seeds')
    infusionCrafting('#forge:storage_blocks/apatite', ess2, baseSeed, 'mysticalagriculture:apatite_seeds');
    infusionCrafting('thermal:cured_rubber_block', ess2, baseSeed, 'mysticalagriculture:rubber_seeds');
    infusionCrafting('#forge:storage_blocks/niter', ess2, baseSeed, 'mysticalagriculture:saltpeter_seeds');
    infusionCrafting('#forge:storage_blocks/sulfur', ess2, baseSeed, 'mysticalagriculture:sulfur_seeds');

    //Tier 3 recipes
    const ess3 = 'mysticalagriculture:tertium_essence';
    infusionCrafting('#forge:storage_blocks/iron', ess3, baseSeed, 'mysticalagriculture:iron_seeds');
    infusionCrafting('#forge:storage_blocks/copper', ess3, baseSeed, 'mysticalagriculture:copper_seeds');
    infusionCrafting('minecraft:quartz_block', ess3, baseSeed, 'mysticalagriculture:nether_quartz_seeds');
    infusionCrafting('minecraft:glowstone', ess3, baseSeed, 'mysticalagriculture:glowstone_seeds');
    infusionCrafting('#forge:storage_blocks/redstone', ess3, baseSeed, 'mysticalagriculture:redstone_seeds');
    infusionCrafting('minecraft:sea_lantern', ess3, baseSeed, 'mysticalagriculture:prismarine_seeds');
    infusionCrafting('#forge:storage_blocks/zinc', ess3, baseSeed, 'mysticalagriculture:zinc_seeds');
    infusionCrafting('#forge:storage_blocks/brass', ess3, baseSeed, 'mysticalagriculture:brass_seeds');
    infusionCrafting('#forge:storage_blocks/silver', ess3, baseSeed, 'mysticalagriculture:silver_seeds');
    infusionCrafting('#forge:storage_blocks/lead', ess3, baseSeed, 'mysticalagriculture:lead_seeds');
    infusionCrafting('#forge:storage_blocks/certus_quartz', ess3, baseSeed, 'mysticalagriculture:certus_quartz_seeds');
    infusionCrafting('#forge:storage_blocks/manasteel', ess3, baseSeed, 'mysticalagriculture:manasteel_seeds');
    infusionCrafting('#forge:storage_blocks/bronze', ess3, baseSeed, 'mysticalagriculture:bronze_seeds');
    infusionCrafting('#forge:storage_blocks/tin', ess3, baseSeed, 'mysticalagriculture:tin_seeds');
    infusionCrafting('#forge:storage_blocks/aquamarine', ess3, baseSeed, 'mysticalagriculture:aquamarine_seeds');
    infusionCrafting('#forge:storage_blocks/slimesteel', ess3, baseSeed, 'mysticalagriculture:slimesteel_seeds');
    infusionCrafting('#forge:storage_blocks/pig_iron', ess3, baseSeed, 'mysticalagriculture:pig_iron_seeds');
    infusionCrafting('#forge:storage_blocks/amethyst_bronze', ess3, baseSeed, 'mysticalagriculture:amethyst_bronze_seeds');

    //Tier 4 recipes
    const ess4 = 'mysticalagriculture:imperium_essence';
    infusionCrafting('#forge:storage_blocks/gold', ess4, baseSeed, 'mysticalagriculture:gold_seeds');
    infusionCrafting('#forge:storage_blocks/lapis', ess4, baseSeed, 'mysticalagriculture:lapis_lazuli_seeds');
    infusionCrafting('#forge:storage_blocks/steel', ess4, baseSeed, 'mysticalagriculture:steel_seeds');
    infusionCrafting('#forge:storage_blocks/nickel', ess4, baseSeed, 'mysticalagriculture:nickel_seeds');
    infusionCrafting('#forge:storage_blocks/constantan', ess4, baseSeed, 'mysticalagriculture:constantan_seeds');
    infusionCrafting('#forge:storage_blocks/electrum', ess4, baseSeed, 'mysticalagriculture:electrum_seeds');
    infusionCrafting('#forge:storage_blocks/uranium', ess4, baseSeed, 'mysticalagriculture:uranium_seeds');
    infusionCrafting('jaopca:storage_blocks.hop_graphite', ess4, baseSeed, 'mysticalagriculture:hop_graphite_seeds');
    infusionCrafting('ae2:fluix_block', ess4, baseSeed, 'mysticalagriculture:fluix_seeds');
    infusionCrafting('#forge:storage_blocks/elementium', ess4, baseSeed, 'mysticalagriculture:elementium_seeds');
    infusionCrafting('#forge:storage_blocks/osmium', ess4, baseSeed, 'mysticalagriculture:osmium_seeds');
    infusionCrafting('#forge:storage_blocks/fluorite', ess4, baseSeed, 'mysticalagriculture:fluorite_seeds');
    infusionCrafting('#forge:storage_blocks/refined_obsidian', ess4, baseSeed, 'mysticalagriculture:refined_obsidian_seeds');
    infusionCrafting('#forge:storage_blocks/refined_glowstone', ess4, baseSeed, 'mysticalagriculture:refined_glowstone_seeds');
    infusionCrafting('#forge:storage_blocks/compressed_iron', ess4, baseSeed, 'mysticalagriculture:compressed_iron_seeds');
    infusionCrafting('#forge:storage_blocks/signalum', ess4, baseSeed, 'mysticalagriculture:signalum_seeds');
    infusionCrafting('#forge:storage_blocks/cobalt', ess4, baseSeed, 'mysticalagriculture:cobalt_seeds');
    infusionCrafting('#forge:storage_blocks/ruby', ess4, baseSeed, 'mysticalagriculture:ruby_seeds');
    infusionCrafting('#forge:storage_blocks/sapphire', ess4, baseSeed, 'mysticalagriculture:sapphire_seeds');
    infusionCrafting('#forge:storage_blocks/rose_gold', ess4, baseSeed, 'mysticalagriculture:rose_gold_seeds');
    infusionCrafting('#forge:storage_blocks/lumium', ess4, baseSeed, 'mysticalagriculture:lumium_seeds');
    infusionCrafting('#forge:storage_blocks/invar', ess4, baseSeed, 'mysticalagriculture:invar_seeds');

    //Tier 5 recipes
    const ess5 = 'mysticalagriculture:supremium_essence';
    infusionCrafting('#forge:storage_blocks/diamond', ess5, baseSeed, 'mysticalagriculture:diamond_seeds');
    infusionCrafting('#forge:storage_blocks/emerald', ess5, baseSeed, 'mysticalagriculture:emerald_seeds');
    infusionCrafting('#forge:storage_blocks/netherite', ess5, baseSeed, 'mysticalagriculture:netherite_seeds');
    infusionCrafting('#forge:storage_blocks/terrasteel', ess5, baseSeed, 'mysticalagriculture:terrasteel_seeds');
    infusionCrafting('#forge:storage_blocks/enderium', ess5, baseSeed, 'mysticalagriculture:enderium_seeds');
    infusionCrafting('#forge:storage_blocks/manyullyn', ess5, baseSeed, 'mysticalagriculture:manyullyn_seeds');
    infusionCrafting('#forge:storage_blocks/hepatizon', ess5, baseSeed, 'mysticalagriculture:hepatizon_seeds');
    infusionCrafting('#forge:storage_blocks/queens_slime', ess5, baseSeed, 'mysticalagriculture:queens_slime_seeds');

    //Earth essence more uses (focused on grass)
    event.shaped('8x minecraft:grass', ['EEE', '   ', '   '], {
        E: 'mysticalagriculture:earth_essence'
    });
    event.shaped('8x minecraft:fern', ['   ', 'EEE', '   '], {
        E: 'mysticalagriculture:earth_essence'
    });
    event.shaped('8x minecraft:dead_bush', ['   ', '   ', 'EEE'], {
        E: 'mysticalagriculture:earth_essence'
    });

    //Basalt
    event.shaped('20x minecraft:basalt', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:basalt_essence'
    }).id('mysticalagriculture:essence/minecraft/basalt');

    //Limestone
    event.shaped('10x quark:limestone', ['EEE', ' E ', '   '], {
        E: 'mysticalagriculture:limestone_essence'
    });
    event.shaped('10x create:limestone', ['E  ', 'EE ', 'E  '], {
        E: 'mysticalagriculture:limestone_essence'
    });

    //Silicon
    event.shaped('4x ae2:silicon', ['EEE', 'E  ', '   '], {
        E: 'mysticalagriculture:silicon_essence'
    }).id('mysticalagriculture:essence/common/silicon');

    //Aluminum
    event.shaped('2x immersiveengineering:ingot_aluminum', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:aluminum_essence'
    }).id('mysticalagriculture:essence/common/aluminum_ingot');

    //Iron
    event.shaped('2x minecraft:iron_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:iron_essence'
    }).id('mysticalagriculture:essence/minecraft/iron_ingot');

    //Copper
    event.shaped('2x minecraft:copper_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:copper_essence'
    });

    //Quartz
    event.shaped('6x minecraft:quartz', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:nether_quartz_essence'
    }).id('mysticalagriculture:essence/minecraft/quartz');

    //Glowstone Dust
    event.shaped('6x minecraft:glowstone_dust', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:glowstone_essence'
    }).id('mysticalagriculture:essence/minecraft/glowstone_dust');

    //Redstone
    event.shaped('6x minecraft:redstone', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:redstone_essence'
    }).id('mysticalagriculture:essence/minecraft/redstone');

    //Obsidian
    event.shaped('4x minecraft:obsidian', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:obsidian_essence'
    }).id('mysticalagriculture:essence/minecraft/obsidian');

    //Pig Iron
    event.shaped('2x tconstruct:pig_iron_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:pig_iron_essence'
    }).id('mysticalagriculture:essence/tconstruct/pig_iron_ingot');

    //Slimesteel
    event.shaped('2x tconstruct:slimesteel_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:slimesteel_essence'
    }).id('mysticalagriculture:essence/tconstruct/slimesteel_ingot');

    //Amethyst bronze
    event.shaped('2x tconstruct:amethyst_bronze_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:amethyst_bronze_essence'
    }).id('mysticalagriculture:essence/tconstruct/amethyst_bronze_ingot');

    //Lead
    event.shaped('2x thermal:lead_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:lead_essence'
    }).id('mysticalagriculture:essence/common/lead_ingot');

    //Silver
    event.shaped('2x thermal:silver_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:silver_essence'
    }).id('mysticalagriculture:essence/common/silver_ingot');

    //Brass
    event.shaped('2x create:brass_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:brass_essence'
    }).id('mysticalagriculture:essence/common/brass_ingot');

    //Zinc
    event.shaped('2x create:zinc_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:zinc_essence'
    }).id('mysticalagriculture:essence/common/zinc_ingot');

    //Gold
    event.shaped('2x minecraft:gold_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:gold_essence'
    }).id('mysticalagriculture:essence/minecraft/gold_ingot');

    //Lapis
    event.shaped('6x minecraft:lapis_lazuli', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:lapis_lazuli_essence'
    }).id('mysticalagriculture:essence/minecraft/lapis_lazuli');

    //Ender Pearl
    event.shaped('2x minecraft:ender_pearl', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:enderman_essence'
    }).id('mysticalagriculture:essence/minecraft/ender_pearl');

    //Eye of Ender
    event.shaped('2x minecraft:ender_eye', ['EEE', 'EBE', 'EEE'], {
        E: 'mysticalagriculture:enderman_essence',
        B: 'mysticalagriculture:blaze_essence'
    }).id('mysticalagriculture:essence/minecraft/ender_eye');

    //Steel
    event.shaped('2x mekanism:ingot_steel', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:steel_essence'
    }).id('mysticalagriculture:essence/common/steel_ingot');

    //Nickel
    event.shaped('2x thermal:nickel_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:nickel_essence'
    }).id('mysticalagriculture:essence/common/nickel_ingot');

    //Constantan
    event.shaped('2x thermal:constantan_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:constantan_essence'
    }).id('mysticalagriculture:essence/common/constantan_ingot');

    //Electrum
    event.shaped('2x thermal:electrum_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:electrum_essence'
    }).id('mysticalagriculture:essence/common/electrum_ingot');

    //Uranium
    event.shaped('2x mekanism:ingot_uranium', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:uranium_essence'
    }).id('mysticalagriculture:essence/common/uranium_ingot');

    //Emerald
    event.shaped('2x minecraft:emerald', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:emerald_essence'
    }).id('mysticalagriculture:essence/minecraft/emerald');

    //Diamond
    event.shaped('2x minecraft:diamond', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:diamond_essence'
    }).id('mysticalagriculture:essence/minecraft/diamond');

    //Rose Gold
    event.shaped('2x tconstruct:rose_gold_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:rose_gold_essence'
    }).id('mysticalagriculture:essence/tconstruct/rose_gold_ingot');

    //Manasteel
    event.shaped('2x botania:manasteel_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:manasteel_essence'
    }).id('mysticalagriculture:essence/botania/manasteel_ingot');

    //Cobalt
    event.shaped('2x tconstruct:cobalt_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:cobalt_essence'
    }).id('mysticalagriculture:essence/tconstruct/cobalt_ingot');

    //Elementium
    event.shaped('2x botania:elementium_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:elementium_essence'
    }).id('mysticalagriculture:essence/botania/elementium_ingot');

    //Manyullyn
    event.shaped('tconstruct:manyullyn_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:manyullyn_essence'
    }).id('mysticalagriculture:essence/tconstruct/manyullyn_ingot');

    //Terrasteel
    event.shaped('botania:terrasteel_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:terrasteel_essence'
    }).id('mysticalagriculture:essence/botania/terrasteel_ingot');

    //Runewood
    event.shaped('16x malum:runewood_log', ['EEE', '   ', '   '], {
        E: 'mysticalagriculture:runewood_essence'
    });

    //Archwood
    event.shaped('8x ars_nouveau:blue_archwood_log', ['EEE', '   ', '   '], {
        E: 'mysticalagriculture:archwood_essence'
    });
    event.shaped('8x ars_nouveau:red_archwood_log', ['E  ', 'E  ', 'E  '], {
        E: 'mysticalagriculture:archwood_essence'
    });
    event.shaped('8x ars_nouveau:green_archwood_log', ['E  ', ' E ', '  E'], {
        E: 'mysticalagriculture:archwood_essence'
    });
    event.shaped('8x ars_nouveau:purple_archwood_log', ['  E', ' E ', 'E  '], {
        E: 'mysticalagriculture:archwood_essence'
    });

    //Source Gem
    event.shaped('2x ars_nouveau:source_gem', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:source_gem_essence'
    });

    //Hallowed Gold
    event.shaped('2x malum:hallowed_gold_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:hallowed_gold_essence'
    });

    //Soul Stained Steel
    event.shaped('malum:soul_stained_steel_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:soul_stained_steel_essence'
    });

    //Bronze
    event.shaped('2x thermal:bronze_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:bronze_essence'
    }).id('mysticalagriculture:essence/common/bronze_ingot');

    //Tin
    event.shaped('2x thermal:tin_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:tin_essence'
    }).id('mysticalagriculture:essence/common/tin_ingot');

    //Osmium
    event.shaped('2x mekanism:ingot_osmium', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:osmium_essence'
    }).id('mysticalagriculture:essence/mekanism/osmium_ingot');

    //Fluorite
    event.shaped('6x mekanism:fluorite_gem', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:fluorite_essence'
    }).id('mysticalagriculture:essence/mekanism/fluorite');

    //Refined Glowstone
    event.shaped('2x mekanism:ingot_refined_glowstone', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:refined_glowstone_essence'
    }).id('mysticalagriculture:essence/mekanism/refined_glowstone_ingot');

    //Compressed Iron
    event.shaped('2x pneumaticcraft:ingot_iron_compressed', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:compressed_iron_essence'
    }).id('mysticalagriculture:essence/pneumaticcraft/compressed_iron_ingot');

    //Sulfur
    event.shaped('8x thermal:sulfur_dust', ['EEE', '   ', '   '], {
        E: 'mysticalagriculture:sulfur_essence'
    }).id('mysticalagriculture:essence/common/sulfur');

    //Aquamarine
    event.shaped('6x hearthstones:aquamarine', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:aquamarine_essence'
    });

    //Rubber
    event.shaped('2x thermal:cured_rubber', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:rubber_essence'
    }).id('mysticalagriculture:essence/common/rubber');

    //Invar
    event.shaped('2x thermal:invar_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:invar_essence'
    }).id('mysticalagriculture:essence/common/invar_ingot');

    //Lumium
    event.shaped('2x thermal:lumium_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:lumium_essence'
    }).id('mysticalagriculture:essence/thermal/lumium_ingot');

    //Signalum
    event.shaped('2x thermal:signalum_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:signalum_essence'
    }).id('mysticalagriculture:essence/thermal/signalum_ingot');

    //Enderium
    event.shaped('thermal:enderium_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:enderium_essence'
    }).id('mysticalagriculture:essence/thermal/enderium_ingot');

    //Sapphire
    event.shaped('6x thermal:sapphire', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:sapphire_essence'
    }).id('mysticalagriculture:essence/gems/sapphire');

    //Ruby
    event.shaped('6x thermal:ruby', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:ruby_essence'
    }).id('mysticalagriculture:essence/gems/ruby');

    //Hepatizon
    event.shaped('tconstruct:hepatizon_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:hepatizon_essence'
    }).id('mysticalagriculture:essence/tconstruct/hepatizon_ingot');

    //Queen Slime
    event.shaped('tconstruct:queens_slime_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:queens_slime_essence'
    }).id('mysticalagriculture:essence/tconstruct/queens_slime_ingot');

    //Iesnium
    event.shaped('2x occultism:iesnium_ingot', ['EEE', 'E E', 'EEE'], {
        E: 'mysticalagriculture:iesnium_essence'
    });

    //Heart of the sea
    event.shaped('minecraft:heart_of_the_sea', ['SDP', 'DHD', 'PDS'], {
        S: 'mysticalagriculture:squid_essence',
        D: 'mysticalagriculture:diamond_essence',
        P: 'mysticalagriculture:prismarine_essence',
        H: '#forge:heart'
    }).id('mysticalagriculture:essence/minecraft/heart_of_the_sea');

    //MATC Crystals
    event.shaped('matc:inferium_crystal', ['EPE', 'PGP', 'EPE'], {
        E: 'mysticalagriculture:inferium_essence',
        P: 'mysticalagriculture:prosperity_block',
        G: 'mysticalagriculture:inferium_gemstone'
    }).id('matc:crystals/inferium');

    event.shaped('matc:prudentium_crystal', ['EPE', 'PGP', 'EPE'], {
        E: 'mysticalagriculture:prudentium_essence',
        P: 'mysticalagriculture:prosperity_block',
        G: Item.of('matc:inferium_crystal').ignoreNBT()
    }).id('matc:crystals/prudentium');

    event.shaped('matc:tertium_crystal', ['EPE', 'PGP', 'EPE'], {
        E: 'mysticalagriculture:tertium_essence',
        P: 'mysticalagriculture:prosperity_block',
        G: Item.of('matc:prudentium_crystal').ignoreNBT()
    }).id('matc:crystals/tertium');

    event.shaped('matc:imperium_crystal', ['EPE', 'PGP', 'EPE'], {
        E: 'mysticalagriculture:imperium_essence',
        P: 'mysticalagriculture:prosperity_block',
        G: Item.of('matc:tertium_crystal').ignoreNBT()
    }).id('matc:crystals/imperium');

    event.shaped('mysticalagriculture:master_infusion_crystal', ['EPE', 'PGP', 'EPE'], {
        E: 'mysticalagriculture:supremium_essence',
        P: 'mysticalagriculture:prosperity_block',
        G: Item.of('matc:imperium_crystal').ignoreNBT()
    }).id('matc:crystals/master_infusion_crystal_superium');

    //Seed base and inferium seed
    event.shaped('mysticalagriculture:prosperity_seed_base', [' P ', 'PSP', ' P '], {
        S: '#forge:seeds',
        P: 'mysticalagriculture:prosperity_block'
    }).id('mysticalagriculture:prosperity_seed_base');

    event.shaped('mysticalagriculture:inferium_seeds', ['III', 'ISI', 'III'], {
        S: '#forge:seeds',
        I: 'mysticalagriculture:inferium_block'
    }).id('mysticalagriculture:inferium_seeds');

    //Growth accelerators
    const essenceTiers = ['inferium', 'prudentium', 'tertium', 'imperium', 'supremium'];
    essenceTiers.forEach((tier) =>  {
        event.shaped('mysticalagriculture:' + tier + '_growth_accelerator', ['EFE', 'SDS', 'ESE'], {
            E: 'mysticalagriculture:' + tier + '_ingot',
            S: 'pneumaticcraft:reinforced_stone',
            D: 'mysticalagriculture:' + tier + '_gemstone',
            F: 'farmersdelight:rich_soil'
        }).id('mysticalagriculture:' + tier + '_growth_accelerator');
    });

    //Odd recipes that are 2x2/shapeless but don't work in a 2x2 crafting grid.
    //Fix only those, the rest of 2x2 are shaped 3x3 for a reason to avoid recipe conflicts.
    event.shaped('minecraft:poisonous_potato', ['#forge:crops/potato', 'mysticalagriculture:nature_essence']).id('mysticalagriculture:essence/minecraft/poisonous_potato')
    
    event.shaped('16x minecraft:gravel', ['AB', 'BA'], {
        A: 'mysticalagriculture:dirt_essence',
        B: 'mysticalagriculture:stone_essence'
    }).id('mysticalagriculture:essence/minecraft/gravel')

    event.shaped('24x minecraft:clay_ball', ['AB', 'BA'], {
        A: 'mysticalagriculture:water_essence',
        B: 'mysticalagriculture:dirt_essence'
    }).id('mysticalagriculture:essence/minecraft/clay_ball')

    event.shaped('8x minecraft:flint', ['AB', 'BA'], {
        A: 'mysticalagriculture:stone_essence',
        B: 'mysticalagriculture:fire_essence'
    }).id('mysticalagriculture:essence/minecraft/flint')
});

//Bosses drops supremium essence x4
//'botania:doppleganger' (Guardian of Gaia) doesn't work though.
onEvent('entity.loot_tables', event => {
    var bosses = ['minecraft:wither', 'minecraft:ender_dragon', 'ars_nouveau:wilden_boss'];
    bosses.forEach((boss) => {
        event.modifyEntity(boss, table => {
            table.addPool(pool => {
                pool.rolls = 1
                pool.addEntry({
                    'type': 'minecraft:item',
                    'functions': [{
                        'function': 'set_count',
                        'count': 4
                    }],
                    'name': 'mysticalagriculture:supremium_essence'
                });
            });
        });
    });
});
